/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawning;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.core.info.SpawnInfo;
import com.lycanitesmobs.core.mobevent.MobEventBase;
import com.lycanitesmobs.core.spawning.CoordSorterNearest;
import com.lycanitesmobs.core.spawning.CustomSpawner;
import com.lycanitesmobs.core.spawning.SpawnTypeBlock;
import com.lycanitesmobs.core.spawning.SpawnTypeCrop;
import com.lycanitesmobs.core.spawning.SpawnTypeDarkness;
import com.lycanitesmobs.core.spawning.SpawnTypeDeath;
import com.lycanitesmobs.core.spawning.SpawnTypeFishing;
import com.lycanitesmobs.core.spawning.SpawnTypeLunar;
import com.lycanitesmobs.core.spawning.SpawnTypePortal;
import com.lycanitesmobs.core.spawning.SpawnTypeRock;
import com.lycanitesmobs.core.spawning.SpawnTypeSky;
import com.lycanitesmobs.core.spawning.SpawnTypeSleep;
import com.lycanitesmobs.core.spawning.SpawnTypeStorm;
import com.lycanitesmobs.core.spawning.SpawnTypeTree;
import com.lycanitesmobs.core.spawning.SpawnTypeUndeath;
import com.lycanitesmobs.core.spawning.SpawnTypeUnderground;
import com.lycanitesmobs.core.spawning.SpawnTypeWater;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.eventhandler.Event;

public class SpawnTypeBase {
    public static Map<String, SpawnTypeBase> spawnTypeMap = new HashMap<String, SpawnTypeBase>();
    public static int rangeMin = 10;
    public String typeName;
    public boolean enabled = true;
    public List<SpawnInfo> spawnList = new ArrayList<SpawnInfo>();
    public Map<SpawnInfo, Integer> spawnWaveLimits = new HashMap<SpawnInfo, Integer>();
    public Map<SpawnInfo, Integer> currentSpawnWaveCount;
    public MobEventBase mobEvent = null;
    public int rate;
    public double chance;
    public int range;
    public int blockLimit;
    public int mobLimit;
    public Block[] blocks = null;
    public String[] blockStrings = null;
    public Material[] materials = null;
    public boolean ignoreBiome = false;
    public boolean ignoreDimension = false;
    public boolean ignoreLight = true;
    public boolean ignoreRangeMin = false;
    public boolean ignoreMobConditions = false;
    public boolean forceSpawning = false;
    public boolean forceNoDespawn = false;
    public boolean blockSurfaceOnly = false;

    public static void loadSpawnTypes() {
        ArrayList<SpawnTypeBase> spawnTypes = new ArrayList<SpawnTypeBase>();
        SpawnTypeBase fireBlockSpawner = new SpawnTypeBlock("Fire").setRate(400).setChance(0.5).setRange(32).setBlockLimit(32).setMobLimit(8);
        fireBlockSpawner.blocks = new Block[]{Blocks.field_150480_ab};
        fireBlockSpawner.ignoreBiome = true;
        fireBlockSpawner.ignoreLight = true;
        fireBlockSpawner.blockSurfaceOnly = true;
        fireBlockSpawner.loadFromConfig();
        CustomSpawner.instance.updateSpawnTypes.add(fireBlockSpawner);
        spawnTypes.add(fireBlockSpawner);
        SpawnTypeBase frostfireBlockSpawner = new SpawnTypeBlock("Frostfire").setRate(400).setChance(0.5).setRange(32).setBlockLimit(32).setMobLimit(8);
        frostfireBlockSpawner.blockStrings = new String[]{"frostfire"};
        frostfireBlockSpawner.ignoreBiome = true;
        frostfireBlockSpawner.ignoreLight = true;
        frostfireBlockSpawner.blockSurfaceOnly = true;
        frostfireBlockSpawner.loadFromConfig();
        CustomSpawner.instance.updateSpawnTypes.add(frostfireBlockSpawner);
        spawnTypes.add(frostfireBlockSpawner);
        SpawnTypeBase undergroundSpawner = new SpawnTypeUnderground("Underground").setRate(800).setChance(0.25).setRange(32).setBlockLimit(16).setMobLimit(8);
        undergroundSpawner.materials = new Material[]{Material.field_151579_a};
        undergroundSpawner.ignoreBiome = false;
        undergroundSpawner.ignoreLight = false;
        undergroundSpawner.loadFromConfig();
        CustomSpawner.instance.updateSpawnTypes.add(undergroundSpawner);
        spawnTypes.add(undergroundSpawner);
        SpawnTypeBase skySpawner = new SpawnTypeSky("Sky").setRate(800).setChance(0.5).setRange(48).setBlockLimit(16).setMobLimit(8);
        skySpawner.materials = new Material[]{Material.field_151579_a};
        skySpawner.ignoreBiome = false;
        skySpawner.ignoreLight = false;
        skySpawner.loadFromConfig();
        CustomSpawner.instance.updateSpawnTypes.add(skySpawner);
        spawnTypes.add(skySpawner);
        SpawnTypeBase waterSpawner = new SpawnTypeWater("Water").setRate(400).setChance(0.75).setRange(32).setBlockLimit(64).setMobLimit(16);
        waterSpawner.blocks = new Block[]{Blocks.field_150355_j};
        waterSpawner.ignoreBiome = false;
        waterSpawner.ignoreLight = false;
        waterSpawner.loadFromConfig();
        CustomSpawner.instance.updateSpawnTypes.add(waterSpawner);
        spawnTypes.add(waterSpawner);
        SpawnTypeBase lavaBlockSpawner = new SpawnTypeBlock("Lava").setRate(400).setChance(0.5).setRange(32).setBlockLimit(64).setMobLimit(8);
        lavaBlockSpawner.blocks = new Block[]{Blocks.field_150353_l};
        lavaBlockSpawner.ignoreBiome = true;
        lavaBlockSpawner.ignoreLight = true;
        lavaBlockSpawner.loadFromConfig();
        CustomSpawner.instance.updateSpawnTypes.add(lavaBlockSpawner);
        spawnTypes.add(lavaBlockSpawner);
        SpawnTypeBase spawner = new SpawnTypeBlock("Ooze").setRate(400).setChance(0.5).setRange(32).setBlockLimit(64).setMobLimit(8);
        spawner.blockStrings = new String[]{"ooze"};
        spawner.ignoreBiome = true;
        spawner.ignoreLight = true;
        spawner.loadFromConfig();
        CustomSpawner.instance.updateSpawnTypes.add(spawner);
        spawnTypes.add(spawner);
        SpawnTypeBase portalBlockSpawner = new SpawnTypePortal("Portal").setRate(1200).setChance(0.25).setRange(32).setBlockLimit(32).setMobLimit(1);
        portalBlockSpawner.blocks = new Block[]{Blocks.field_150427_aO};
        portalBlockSpawner.ignoreBiome = true;
        portalBlockSpawner.ignoreDimension = true;
        portalBlockSpawner.ignoreLight = true;
        portalBlockSpawner.forceSpawning = true;
        portalBlockSpawner.loadFromConfig();
        CustomSpawner.instance.updateSpawnTypes.add(portalBlockSpawner);
        spawnTypes.add(portalBlockSpawner);
        SpawnTypeBase rockSpawner = new SpawnTypeRock("Rock").setRate(0).setChance(0.02).setRange(2).setBlockLimit(32).setMobLimit(1);
        rockSpawner.materials = new Material[]{Material.field_151579_a};
        rockSpawner.ignoreBiome = true;
        rockSpawner.ignoreLight = true;
        rockSpawner.forceSpawning = true;
        rockSpawner.loadFromConfig();
        spawnTypes.add(rockSpawner);
        SpawnTypeBase cropSpawner = new SpawnTypeCrop("Crop").setRate(0).setChance(0.005).setRange(2).setBlockLimit(32).setMobLimit(1);
        cropSpawner.materials = new Material[]{Material.field_151579_a};
        cropSpawner.ignoreBiome = true;
        cropSpawner.ignoreLight = true;
        cropSpawner.forceSpawning = true;
        cropSpawner.loadFromConfig();
        spawnTypes.add(cropSpawner);
        SpawnTypeBase treeSpawner = new SpawnTypeTree("Tree").setRate(0).setChance(0.01).setRange(2).setBlockLimit(32).setMobLimit(1);
        treeSpawner.materials = new Material[]{Material.field_151579_a};
        treeSpawner.ignoreBiome = true;
        treeSpawner.ignoreLight = true;
        treeSpawner.forceSpawning = true;
        treeSpawner.loadFromConfig();
        spawnTypes.add(treeSpawner);
        SpawnTypeBase stormSpawner = new SpawnTypeStorm("Storm").setRate(800).setChance(0.125).setRange(48).setBlockLimit(32).setMobLimit(8);
        stormSpawner.materials = new Material[]{Material.field_151579_a};
        stormSpawner.ignoreBiome = true;
        stormSpawner.ignoreLight = true;
        stormSpawner.forceSpawning = true;
        stormSpawner.loadFromConfig();
        spawnTypes.add(stormSpawner);
        SpawnTypeBase lunarSpawner = new SpawnTypeLunar("Lunar").setRate(800).setChance(0.125).setRange(48).setBlockLimit(32).setMobLimit(8);
        lunarSpawner.materials = new Material[]{Material.field_151579_a};
        lunarSpawner.ignoreBiome = true;
        lunarSpawner.ignoreDimension = false;
        lunarSpawner.ignoreLight = false;
        lunarSpawner.forceSpawning = true;
        lunarSpawner.loadFromConfig();
        spawnTypes.add(lunarSpawner);
        SpawnTypeBase darknessSpawner = new SpawnTypeDarkness("Darkness").setRate(0).setChance(0.1).setRange(2).setBlockLimit(32).setMobLimit(1);
        darknessSpawner.enabled = false;
        darknessSpawner.materials = new Material[]{Material.field_151579_a};
        darknessSpawner.ignoreBiome = true;
        darknessSpawner.ignoreDimension = true;
        darknessSpawner.ignoreLight = true;
        darknessSpawner.forceSpawning = true;
        darknessSpawner.loadFromConfig();
        spawnTypes.add(darknessSpawner);
        SpawnTypeBase deathSpawner = new SpawnTypeDeath("Death").setRate(0).setChance(0.03).setRange(2).setBlockLimit(32).setMobLimit(1);
        deathSpawner.materials = new Material[]{Material.field_151579_a};
        deathSpawner.ignoreBiome = true;
        deathSpawner.ignoreDimension = true;
        deathSpawner.ignoreLight = true;
        deathSpawner.forceSpawning = true;
        deathSpawner.loadFromConfig();
        spawnTypes.add(deathSpawner);
        SpawnTypeBase undeathSpawner = new SpawnTypeUndeath("Undeath").setRate(0).setChance(0.03).setRange(2).setBlockLimit(32).setMobLimit(1);
        undeathSpawner.materials = new Material[]{Material.field_151579_a};
        undeathSpawner.ignoreBiome = true;
        undeathSpawner.ignoreDimension = true;
        undeathSpawner.ignoreLight = true;
        undeathSpawner.forceSpawning = true;
        undeathSpawner.loadFromConfig();
        spawnTypes.add(undeathSpawner);
        SpawnTypeBase sleepSpawner = new SpawnTypeSleep("Sleep").setRate(0).setChance(0.1).setRange(2).setBlockLimit(32).setMobLimit(1);
        sleepSpawner.materials = new Material[]{Material.field_151579_a};
        sleepSpawner.ignoreBiome = true;
        sleepSpawner.ignoreDimension = true;
        sleepSpawner.ignoreLight = true;
        sleepSpawner.forceSpawning = true;
        sleepSpawner.loadFromConfig();
        spawnTypes.add(sleepSpawner);
        SpawnTypeBase fishingSpawner = new SpawnTypeFishing("Fishing").setRate(0).setChance(0.2).setRange(2).setBlockLimit(32).setMobLimit(1);
        fishingSpawner.materials = new Material[]{Material.field_151579_a, Material.field_151586_h};
        fishingSpawner.blocks = new Block[]{Blocks.field_150355_j};
        fishingSpawner.ignoreBiome = true;
        fishingSpawner.ignoreDimension = true;
        fishingSpawner.ignoreLight = true;
        fishingSpawner.forceSpawning = true;
        fishingSpawner.loadFromConfig();
        spawnTypes.add(fishingSpawner);
        for (SpawnTypeBase spawnType : spawnTypes) {
            spawnTypeMap.put(spawnType.typeName.toUpperCase(), spawnType);
            LycanitesMobs.printDebug("CustomSpawner", "Added custom spawn type: " + spawnType.typeName);
        }
    }

    public static SpawnTypeBase getSpawnType(String spawnTypeName) {
        if (spawnTypeMap.containsKey(spawnTypeName)) {
            return spawnTypeMap.get(spawnTypeName);
        }
        return null;
    }

    public static SpawnTypeBase[] getSpawnTypes(String spawnTypeNames) {
        ArrayList<SpawnTypeBase> spawnTypeList = new ArrayList<SpawnTypeBase>();
        for (String spawnTypeName : spawnTypeNames.split(",")) {
            SpawnTypeBase spawnType = SpawnTypeBase.getSpawnType(spawnTypeName);
            if (spawnType == null) continue;
            spawnTypeList.add(spawnType);
        }
        return spawnTypeList.toArray(new SpawnTypeBase[spawnTypeList.size()]);
    }

    public SpawnTypeBase(String typeName) {
        this.typeName = typeName.toUpperCase();
    }

    public void loadFromConfig() {
        ConfigBase config = ConfigBase.getConfig(LycanitesMobs.group, "spawning");
        config.setCategoryComment("Spawners Enabled", "Here you can turn each special spawner on or off.");
        this.enabled = config.getBool("Spawners Enabled", this.getCfgName("Spawn Enabled"), this.enabled);
        config.setCategoryComment("Spawner Ticks", "Here you can set the interval that a spawner will try and spawn in ticks. (20 ticks = 1 second). Increase this and lower and the chance if you are having lag issues, this will make the spawner less frequent but more predicatable.");
        this.rate = config.getInt("Spawner Ticks", this.getCfgName("Spawn Tick"), this.rate);
        config.setCategoryComment("Spawner Chances", "Here you can set the chance that a spawner will try and spawn mobs, this chance is tested after every interval.");
        this.chance = config.getDouble("Spawner Chances", this.getCfgName("Spawn Chance"), this.chance);
        config.setCategoryComment("Spawner Ranges", "Here you can set how far from the player or event location that mobs can be spawned. Lower this is you are having major lag issues.");
        this.range = config.getInt("Spawner Ranges", this.getCfgName("Spawn Range"), this.range);
        config.setCategoryComment("Spawner Block Limits", "Here you can set a maximum limit of how many locations the spawner is allowed to spawn mobs at.");
        this.blockLimit = config.getInt("Spawner Block Limits", this.getCfgName("Spawn Block Limit"), this.blockLimit);
        config.setCategoryComment("Spawner Mob Limits", "Here you can set the limit of how many mobs a spawner can spawn every interval. Be aware that each mob will use it's own Area Spawn Limit which will drastically decrease the number of mobs spawned overall.");
        this.mobLimit = config.getInt("Spawner Mob Limits", this.getCfgName("Spawn Mob Limit"), this.mobLimit);
        config.setCategoryComment("Spawner Checks", "Here you can set whether or not each spawn ignores certain mob checks such as dimension, biome or light level. If Ignores Event is set to true, the spawn type will ignore the mob spawn event meaning that other mods also cannot prevent mob spawns.");
        this.ignoreDimension = config.getBool("Spawner Checks", this.getCfgName("Ignores Dimension"), this.ignoreDimension);
        this.ignoreBiome = config.getBool("Spawner Checks", this.getCfgName("Ignores Biome"), this.ignoreBiome);
        this.ignoreLight = config.getBool("Spawner Checks", this.getCfgName("Ignores Light Level"), this.ignoreLight);
        this.forceSpawning = config.getBool("Spawner Checks", this.getCfgName("Ignores Event"), this.forceSpawning);
    }

    public String getCfgName(String configKey) {
        return this.typeName + " " + configKey;
    }

    public void addSpawn(MobInfo mobInfo) {
        this.addSpawn(mobInfo, 0);
    }

    public void addSpawn(MobInfo mobInfo, int spawnWaveLimit) {
        if (mobInfo == null || mobInfo.spawnInfo == null) {
            return;
        }
        this.spawnList.add(mobInfo.spawnInfo);
        if (spawnWaveLimit > 0) {
            this.spawnWaveLimits.put(mobInfo.spawnInfo, spawnWaveLimit);
        }
    }

    public List<SpawnInfo> getSpawnList() {
        return this.spawnList;
    }

    public boolean hasSpawns() {
        return this.spawnList.size() > 0;
    }

    public boolean spawnMobs(long tick, World world, BlockPos spawnPos, EntityPlayer player, int rank) {
        int mobsSpawned;
        block29: {
            if (!(this.enabled && !SpawnInfo.disableAllSpawning && world != null && world.func_175697_a(spawnPos, this.getRange(world)) && this.getSpawnList() != null && this.getSpawnList().size() >= 1 && this.hasSpawns() && world.func_82736_K().func_82766_b("doMobSpawning"))) {
                return false;
            }
            if (!this.canSpawn(tick, world, spawnPos, rank)) {
                return false;
            }
            LycanitesMobs.printDebug("CustomSpawner", "~0==================== " + this.typeName + " Spawner ====================0~");
            LycanitesMobs.printDebug("CustomSpawner", "Attempting to spawn mobs.");
            this.currentSpawnWaveCount = new HashMap<SpawnInfo, Integer>();
            List<BlockPos> coords = this.getSpawnCoordinates(world, spawnPos);
            if (coords == null) {
                LycanitesMobs.printWarning("CustomSpawner", "Null coordinates! This spawn type might never be able to find coordinates as it has no materials or blocks set, not even air.");
                return false;
            }
            LycanitesMobs.printDebug("CustomSpawner", "Found " + coords.size() + "/" + this.blockLimit + " coordinates for mob spawning.");
            if (coords.size() <= 0) {
                LycanitesMobs.printDebug("CustomSpawner", "No valid coordinates were found, spawning cancelled.");
                return false;
            }
            coords = this.orderCoords(coords, spawnPos);
            coords = this.applyCoordLimits(coords);
            LycanitesMobs.printDebug("CustomSpawner", "Applied coordinate limits. New size is " + coords.size());
            ArrayList<Biome> targetBiomes = new ArrayList<Biome>();
            if (!this.ignoreBiome) {
                for (BlockPos coord : coords) {
                    Biome coordBiome = world.func_180494_b(coord);
                    if (targetBiomes.contains(coordBiome)) continue;
                    targetBiomes.add(coordBiome);
                }
            }
            LycanitesMobs.printDebug("CustomSpawner", "Getting a list of all mobs that can spawn within the found coordinates.");
            List<SpawnInfo> spawnList = this.getSpawnList();
            if (spawnList.isEmpty()) {
                LycanitesMobs.printDebug("CustomSpawner", "No mobs are able to spawn, from this spawn type at all. Spawning cancelled.");
                return false;
            }
            Map<Biome, List<SpawnInfo>> possibleSpawns = this.getPossibleSpawns(spawnList, coords.size(), targetBiomes);
            if (!this.ignoreBiome && (possibleSpawns == null || possibleSpawns.isEmpty())) {
                LycanitesMobs.printDebug("CustomSpawner", "No mobs are able to spawn, either not enough blocks, empty biome/dimension or all weights are 0. Spawning cancelled.");
                return false;
            }
            LycanitesMobs.printDebug("CustomSpawner", "Cycling through each possible spawn coordinate and attempting to spawn a mob there. Mob limit is " + this.mobLimit + " overall.");
            mobsSpawned = 0;
            try {
                for (BlockPos coord : coords) {
                    Event.Result canSpawn;
                    SpawnInfo spawnInfo = null;
                    if (!this.ignoreBiome) {
                        Biome spawnBiome = world.func_180494_b(coord);
                        if (!possibleSpawns.containsKey(spawnBiome)) continue;
                        if (possibleSpawns.get(spawnBiome).isEmpty()) {
                            LycanitesMobs.printWarning("CustomSpawner", "Tried to spawn in " + spawnBiome + " but there are no possible spawns yet it has a list instantiated, skipping.");
                            continue;
                        }
                        spawnInfo = this.getRandomMob(possibleSpawns.get(spawnBiome), world);
                    } else {
                        spawnInfo = this.getRandomMob(spawnList, world);
                    }
                    EntityLiving entityLiving = null;
                    try {
                        entityLiving = (EntityLiving)spawnInfo.mobInfo.entityClass.getConstructor(World.class).newInstance(world);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (entityLiving == null) {
                        LycanitesMobs.printWarning("CustomSpawner", "Unable to instantiate an entity from SpawnInfo: " + spawnInfo);
                        continue;
                    }
                    LycanitesMobs.printDebug("CustomSpawner", "Attempting to spawn " + entityLiving + "...");
                    LycanitesMobs.printDebug("CustomSpawner", "Coordinates: " + coord);
                    entityLiving.func_70012_b((double)coord.func_177958_n() + 0.5, (double)coord.func_177956_o(), (double)coord.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if (entityLiving instanceof EntityCreatureBase) {
                        ((EntityCreatureBase)entityLiving).spawnedFromType = this;
                    }
                    if ((canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityLiving, (World)world, (float)((float)coord.func_177958_n() + 0.5f), (float)coord.func_177956_o(), (float)((float)coord.func_177952_p() + 0.5f))) == Event.Result.DENY && !this.forceSpawning) {
                        LycanitesMobs.printDebug("CustomSpawner", "Spawn Check Failed! Spawning blocked by Forge Event, this is caused another mod.");
                        continue;
                    }
                    boolean validLocation = true;
                    if (!this.ignoreMobConditions) {
                        validLocation = entityLiving.func_70601_bi();
                    } else if (entityLiving instanceof EntityCreatureBase) {
                        LycanitesMobs.printDebug("CustomSpawner", "Ignoring all mob spawn checks except for collision...");
                        boolean ignoreLightTemp = this.ignoreLight;
                        this.ignoreLight = true;
                        validLocation = ((EntityCreatureBase)entityLiving).fixedSpawnCheck(world, coord);
                        this.ignoreLight = ignoreLightTemp;
                    }
                    if (canSpawn == Event.Result.DEFAULT && !validLocation) {
                        LycanitesMobs.printDebug("CustomSpawner", "Spawn Check Failed! The entity may not fit, there may be to many of it in the area, it may require specific lighting, etc.");
                        continue;
                    }
                    entityLiving.field_71088_bW = entityLiving.func_82147_ab();
                    if (entityLiving instanceof EntityCreatureBase) {
                        EntityCreatureBase entityCreature = (EntityCreatureBase)entityLiving;
                        entityCreature.forceNoDespawn = this.forceNoDespawn;
                        entityCreature.spawnedRare = rank > 0;
                        ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
                        if (this.mobEvent != null && worldExt != null) {
                            entityCreature.spawnEventType = this.mobEvent.name;
                            entityCreature.spawnEventCount = worldExt.getWorldEventCount();
                        }
                    }
                    this.spawnEntity(world, entityLiving, rank);
                    if (MobEventBase.aggressiveEvents && this.mobEvent != null && player != null) {
                        entityLiving.func_70624_b((EntityLivingBase)player);
                    }
                    if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entityLiving, (World)world, (float)((float)coord.func_177958_n() + 0.5f), (float)coord.func_177956_o(), (float)((float)coord.func_177952_p() + 0.5f)) && entityLiving instanceof EntityCreatureBase) {
                        entityLiving.func_180482_a(world.func_175649_E(coord), null);
                    }
                    LycanitesMobs.printDebug("CustomSpawner", "Spawn Check Passed! Mob spawned.");
                    ++mobsSpawned;
                    if (!this.currentSpawnWaveCount.containsKey(spawnInfo)) {
                        this.currentSpawnWaveCount.put(spawnInfo, 1);
                    } else {
                        this.currentSpawnWaveCount.put(spawnInfo, this.currentSpawnWaveCount.get(spawnInfo) + 1);
                    }
                    if (mobsSpawned < this.mobLimit) continue;
                    break;
                }
            }
            catch (Exception e) {
                LycanitesMobs.printDebug("CustomSpawner", "An exception occured when spawning " + mobsSpawned + " mobs.");
                if (!LycanitesMobs.config.getBool("Debug", "CustomSpawner", false)) break block29;
                e.printStackTrace();
            }
        }
        LycanitesMobs.printDebug("CustomSpawner", "Spawning finished. Spawned " + mobsSpawned + " mobs.");
        return mobsSpawned > 0;
    }

    public boolean spawnMobs(long tick, World world, BlockPos spawnPos, EntityPlayer player) {
        return this.spawnMobs(tick, world, spawnPos, player, 0);
    }

    public boolean canSpawn(long tick, World world, BlockPos spawnPos, int rank) {
        if (this.getRate(world) == 0 || tick % (long)this.getRate(world) != 0L) {
            return false;
        }
        return !(world.field_73012_v.nextDouble() >= this.chance);
    }

    public List<BlockPos> getSpawnCoordinates(World world, BlockPos originPos) {
        return this.searchForBlockCoords(world, originPos);
    }

    public List<BlockPos> orderCoords(List<BlockPos> coords, BlockPos originPos) {
        Collections.shuffle(coords);
        return coords;
    }

    public List<BlockPos> applyCoordLimits(List<BlockPos> coords) {
        if (coords.size() > this.blockLimit) {
            coords = coords.subList(0, this.blockLimit);
        }
        return coords;
    }

    public Map<Biome, List<SpawnInfo>> getPossibleSpawns(List<SpawnInfo> spawnList, int coordsFound, List<Biome> biomes) {
        HashMap<Biome, List<SpawnInfo>> possibleSpawns = new HashMap<Biome, List<SpawnInfo>>();
        for (SpawnInfo possibleSpawn : spawnList) {
            boolean isEnabled;
            boolean withinWaveLimit = true;
            if (this.spawnWaveLimits.containsKey(possibleSpawn) && this.currentSpawnWaveCount.containsKey(possibleSpawn) && this.currentSpawnWaveCount.get(possibleSpawn) >= this.spawnWaveLimits.get(possibleSpawn)) {
                withinWaveLimit = false;
                LycanitesMobs.printDebug("CustomSpawner", possibleSpawn.mobInfo.name + ": Spawn Wave Limit reached for this mob.");
            }
            if (!((isEnabled = withinWaveLimit) && possibleSpawn != null && possibleSpawn.mobInfo.mobEnabled && possibleSpawn.enabled && possibleSpawn.spawnWeight > 0 && possibleSpawn.spawnGroupMax > 0)) {
                LycanitesMobs.printDebug("CustomSpawner", possibleSpawn.mobInfo.name + ": Not enabled, will not spawn.");
                isEnabled = false;
            }
            boolean enoughCoords = true;
            if (coordsFound < possibleSpawn.spawnBlockCost) {
                LycanitesMobs.printDebug("CustomSpawner", possibleSpawn.mobInfo.name + ": Not enough of the required blocks available for spawning.");
                enoughCoords = false;
            }
            ArrayList<Biome> spawnBiomes = new ArrayList<Biome>();
            if (enoughCoords && possibleSpawn.biomes != null) {
                block1: for (Biome validBiome : possibleSpawn.biomes) {
                    for (Biome targetBiome : biomes) {
                        if (targetBiome != validBiome && !this.ignoreBiome && !possibleSpawn.ignoreBiome) continue;
                        spawnBiomes.add(targetBiome);
                        continue block1;
                    }
                }
            }
            if (spawnBiomes.isEmpty()) {
                LycanitesMobs.printDebug("CustomSpawner", possibleSpawn.mobInfo.name + ": No valid spawning biomes could be found within the coordinates.");
            }
            if (!isEnabled || !enoughCoords || spawnBiomes.isEmpty()) continue;
            LycanitesMobs.printDebug("CustomSpawner", possibleSpawn.mobInfo.name + ": Able to spawn.");
            for (Biome spawnBiome : spawnBiomes) {
                if (!possibleSpawns.containsKey(spawnBiome)) {
                    possibleSpawns.put(spawnBiome, new ArrayList());
                }
                ((List)possibleSpawns.get(spawnBiome)).add(possibleSpawn);
            }
        }
        return possibleSpawns;
    }

    public SpawnInfo getRandomMob(List<SpawnInfo> possibleSpawns, World world) {
        int totalWeights = 0;
        for (SpawnInfo spawnEntry : possibleSpawns) {
            totalWeights += spawnEntry.spawnWeight;
        }
        if (totalWeights <= 0) {
            return null;
        }
        int randomWeight = 1;
        if (totalWeights > 1) {
            randomWeight = world.field_73012_v.nextInt(totalWeights - 1) + 1;
        }
        int searchWeight = 0;
        SpawnInfo spawnInfo = null;
        Iterator<SpawnInfo> iterator = possibleSpawns.iterator();
        while (iterator.hasNext()) {
            SpawnInfo spawnEntry;
            spawnInfo = spawnEntry = iterator.next();
            if (spawnEntry.spawnWeight + searchWeight > randomWeight) break;
            searchWeight += spawnEntry.spawnWeight;
        }
        return spawnInfo;
    }

    public void spawnEntity(World world, EntityLiving entityLiving, int rank) {
        world.func_72838_d((Entity)entityLiving);
        if (this.mobEvent != null && entityLiving != null) {
            this.mobEvent.onSpawn(entityLiving, rank);
        }
    }

    public List<BlockPos> searchForBlockCoords(World world, BlockPos searchPos) {
        ArrayList<BlockPos> blockCoords = null;
        int range = this.getRange(world);
        for (int y = searchPos.func_177956_o() - range; y <= searchPos.func_177956_o() + range; ++y) {
            if (y < 0) {
                y = 0;
            }
            if (y >= world.func_72940_L()) break;
            for (int x = searchPos.func_177958_n() - range; x <= searchPos.func_177958_n() + range; ++x) {
                for (int z = searchPos.func_177952_p() - range; z <= searchPos.func_177952_p() + range; ++z) {
                    float filled;
                    BlockPos spawnPos = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(spawnPos);
                    if (blockState == null || blockState.func_177230_c() instanceof IFluidBlock && (filled = ((IFluidBlock)blockState.func_177230_c()).getFilledPercentage(world, spawnPos)) != 1.0f && filled != -1.0f || blockState.func_177230_c() instanceof BlockLiquid && blockState.func_177230_c().func_176201_c(blockState) != 0) continue;
                    if (this.materials != null && this.materials.length > 0) {
                        if (blockCoords == null) {
                            blockCoords = new ArrayList<BlockPos>();
                        }
                        for (Material validMaterial : this.materials) {
                            if (blockState.func_185904_a() != validMaterial || !this.isValidCoord(world, spawnPos) || this.blockSurfaceOnly && !world.func_175623_d(spawnPos.func_177984_a())) continue;
                            blockCoords.add(spawnPos);
                        }
                    }
                    if (this.blocks != null && this.blocks.length > 0) {
                        if (blockCoords == null) {
                            blockCoords = new ArrayList();
                        }
                        for (Block validBlock : this.blocks) {
                            if (blockState.func_177230_c() != validBlock || this.blockSurfaceOnly && !world.func_175623_d(spawnPos.func_177984_a())) continue;
                            blockCoords.add(spawnPos);
                        }
                    }
                    if (this.blockStrings == null || this.blockStrings.length <= 0) continue;
                    if (blockCoords == null) {
                        blockCoords = new ArrayList();
                    }
                    for (String validBlockString : this.blockStrings) {
                        if (blockState.func_177230_c() != ObjectManager.getBlock(validBlockString) || this.blockSurfaceOnly && !world.func_175623_d(spawnPos.func_177984_a())) continue;
                        blockCoords.add(spawnPos);
                    }
                }
            }
        }
        return blockCoords;
    }

    public BlockPos getRandomLandCoord(World world, BlockPos originPos, int range) {
        int[] xz = this.getRandomXZCoord(world, originPos.func_177958_n(), originPos.func_177952_p(), rangeMin, range);
        int x = xz[0];
        int z = xz[1];
        int y = this.getRandomYCoord(world, new BlockPos(x, originPos.func_177956_o(), z), 0, range, true, Blocks.field_150350_a, false);
        return y > -1 ? new BlockPos(x, y, z) : null;
    }

    public BlockPos getRandomWaterCoord(World world, BlockPos originPos, int range) {
        int[] xz = this.getRandomXZCoord(world, originPos.func_177958_n(), originPos.func_177952_p(), rangeMin, range);
        int x = xz[0];
        int z = xz[1];
        int y = this.getRandomYCoord(world, new BlockPos(x, originPos.func_177956_o(), z), 0, range, false, (Block)Blocks.field_150355_j, false);
        return y > -1 ? new BlockPos(x, y, z) : null;
    }

    public BlockPos getRandomSkyCoord(World world, BlockPos originPos, int range) {
        int[] xz = this.getRandomXZCoord(world, originPos.func_177958_n(), originPos.func_177952_p(), rangeMin, range);
        int x = xz[0];
        int z = xz[1];
        int y = this.getRandomYCoord(world, new BlockPos(x, originPos.func_177956_o(), z), 0, range, false, Blocks.field_150350_a, false);
        return y > -1 ? new BlockPos(x, y, z) : null;
    }

    public int[] getRandomXZCoord(World world, int originX, int originZ, int rangeMin, int rangeMax) {
        float minScale;
        float zScale;
        float xScale = world.field_73012_v.nextFloat();
        if (xScale + (zScale = world.field_73012_v.nextFloat()) < (minScale = (float)rangeMin / (float)rangeMin) * 2.0f) {
            float xShare = world.field_73012_v.nextFloat();
            float zShare = 1.0f - xShare;
            xScale += minScale * xShare;
            zScale += minScale * zShare;
        }
        int x = Math.round((float)rangeMax * xScale);
        int z = Math.round((float)rangeMax * zScale);
        x = world.field_73012_v.nextBoolean() ? originX + x : originX - x;
        z = world.field_73012_v.nextBoolean() ? originZ + z : originZ - z;
        return new int[]{x, z};
    }

    public int getRandomYCoord(World world, BlockPos originPos, int rangeMin, int rangeMax, boolean solidSurface, Block insideBlock, boolean underground) {
        int originX = originPos.func_177958_n();
        int originY = originPos.func_177956_o();
        int originZ = originPos.func_177952_p();
        int minY = Math.max(originY - rangeMax, 0);
        int maxY = originY + rangeMax;
        ArrayList<Integer> yCoordsLow = new ArrayList<Integer>();
        ArrayList<Integer> yCoordsHigh = new ArrayList<Integer>();
        for (int nextY = minY; nextY <= maxY; ++nextY) {
            BlockPos spawnPos;
            IBlockState blockState;
            Block block;
            if (nextY > originY - rangeMin && nextY < originY + rangeMin) {
                nextY = originY + rangeMin;
            }
            if ((block = (blockState = world.func_180495_p(spawnPos = new BlockPos(originX, nextY, originZ))).func_177230_c()) == null || (solidSurface || block != insideBlock) && (!solidSurface || !this.validGroundBlock(blockState, world, spawnPos)) || nextY + 1 > originY - minY && nextY + 1 < originY - maxY) continue;
            if (world.func_175710_j(spawnPos)) {
                BlockPos checkPos = spawnPos;
                if (solidSurface) {
                    checkPos = checkPos.func_177982_a(0, 1, 0);
                }
                if (underground || world.func_180495_p(checkPos).func_177230_c() != insideBlock) break;
                if (!solidSurface) {
                    int skyCoord = nextY;
                    int skyRange = Math.min(world.func_72800_K() - 1, maxY) - skyCoord;
                    if (skyRange > 1) {
                        if (insideBlock != Blocks.field_150350_a) {
                            skyRange = this.getInsideBlockHeight(world, checkPos, insideBlock);
                        }
                        nextY += world.field_73012_v.nextInt(skyRange);
                    }
                    if (skyRange == 1) {
                        nextY = 1;
                    }
                }
                if (nextY + 1 <= 64) {
                    yCoordsLow.add(nextY + 1);
                    break;
                }
                yCoordsHigh.add(nextY + 1);
                break;
            }
            if (!this.doesCoordHaveSpace(world, spawnPos.func_177982_a(0, 1, 0), insideBlock)) continue;
            if (nextY + 1 <= 64) {
                yCoordsLow.add(nextY + 1);
            } else {
                yCoordsHigh.add(nextY + 1);
            }
            nextY += 2;
        }
        int y = -1;
        if (yCoordsHigh.size() > 0 && (yCoordsLow.size() <= 0 || world.field_73012_v.nextFloat() > 0.25f)) {
            y = yCoordsHigh.size() == 1 ? ((Integer)yCoordsHigh.get(0)).intValue() : ((Integer)yCoordsHigh.get(world.field_73012_v.nextInt(yCoordsHigh.size() - 1))).intValue();
        } else if (yCoordsLow.size() > 0) {
            y = yCoordsLow.size() == 1 ? ((Integer)yCoordsLow.get(0)).intValue() : ((Integer)yCoordsLow.get(world.field_73012_v.nextInt(yCoordsLow.size() - 1))).intValue();
        }
        return y;
    }

    public int getInsideBlockHeight(World world, BlockPos startPos, Block insideBlock) {
        BlockPos checkPos;
        int y;
        for (y = startPos.func_177956_o(); y < world.func_72940_L() && world.func_180495_p(checkPos = new BlockPos(startPos.func_177958_n(), y, startPos.func_177952_p())).func_177230_c() == insideBlock; ++y) {
        }
        return y - startPos.func_177956_o();
    }

    public boolean validGroundBlock(IBlockState blockState, World world, BlockPos pos) {
        if (blockState == null) {
            return false;
        }
        try {
            if (blockState.func_185915_l()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (blockState.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) {
                return true;
            }
            if (blockState.isSideSolid((IBlockAccess)world, pos, EnumFacing.DOWN)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean doesCoordHaveSpace(World world, BlockPos pos, Block insideBlock) {
        Block feet = world.func_180495_p(pos).func_177230_c();
        if (feet == null) {
            return false;
        }
        if (feet != insideBlock) {
            return false;
        }
        Block head = world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_177230_c();
        if (head == null) {
            return false;
        }
        return head == insideBlock;
    }

    public BlockPos getRandomChunkCoord(World world, Chunk chunk, int range) {
        range = Math.min(range, 16);
        int x = chunk.field_76635_g + world.field_73012_v.nextInt(range);
        int z = chunk.field_76647_h + world.field_73012_v.nextInt(range);
        int y = world.field_73012_v.nextInt(chunk == null ? world.func_72940_L() : chunk.func_76625_h() + 1);
        return new BlockPos(x += 16 - range, y, z += 16 - range);
    }

    public boolean isValidCoord(World world, BlockPos pos) {
        return true;
    }

    public List<BlockPos> orderCoordsCloseToFar(List<BlockPos> coords, BlockPos originPos) {
        Collections.sort(coords, new CoordSorterNearest(originPos));
        return coords;
    }

    public SpawnTypeBase setRate(int integer) {
        this.rate = integer;
        return this;
    }

    public SpawnTypeBase setChance(double dbl) {
        this.chance = dbl;
        return this;
    }

    public SpawnTypeBase setRange(int integer) {
        this.range = integer;
        return this;
    }

    public SpawnTypeBase setBlockLimit(int integer) {
        this.blockLimit = integer;
        return this;
    }

    public SpawnTypeBase setMobLimit(int integer) {
        this.mobLimit = integer;
        return this;
    }

    public SpawnTypeBase setMobEvent(MobEventBase mobEvent) {
        this.mobEvent = mobEvent;
        this.forceSpawning = mobEvent.forceSpawning;
        this.forceNoDespawn = mobEvent.forceNoDespawn;
        return this;
    }

    public int getRate(World world) {
        if (this.mobEvent != null) {
            return this.mobEvent.getRate(world);
        }
        return this.rate;
    }

    public int getRange(World world) {
        if (this.mobEvent != null) {
            return this.mobEvent.getRange(world);
        }
        return this.range;
    }
}

